<?php

namespace App\Models\Account;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExchangeAccount extends Model 
{

    protected $table = 'exchange_accounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('account_id', 'account_name', 'api_key', 'api_secret', 'exchange_id', 'competition_count');

    public function exchange()
    {
        return $this->belongsTo('Exchange');
    }

    public function account()
    {
        return $this->belongsTo('Account');
    }

}